/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware;

import jace.Emulator;
import jace.config.ConfigurableField;
import jace.config.Name;
import jace.config.Reconfigurable;
import jace.core.Card;
import jace.core.Motherboard;
import jace.core.RAMEvent;
import jace.core.Utility;
import jace.hardware.DiskIIDrive;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

@Name(value="Disk ][ Controller")
public class CardDiskII
extends Card
implements Reconfigurable {
    @ConfigurableField(name="Disk 1", shortName="d1")
    public File disk1;
    @ConfigurableField(name="Disk 2", shortName="d2")
    public File disk2;
    DiskIIDrive currentDrive;
    DiskIIDrive drive1;
    DiskIIDrive drive2;
    @ConfigurableField(category="Disk", defaultValue="254", name="Default volume", description="Value to use for disk volume number")
    public static int DEFAULT_VOLUME_NUMBER = 254;
    @ConfigurableField(category="Disk", defaultValue="true", name="Speed boost", description="If enabled, emulator will run at max speed during disk access")
    public static boolean USE_MAX_SPEED = true;
    ImageIcon diskDrive1Icon;
    ImageIcon diskDrive2Icon;

    public CardDiskII() {
        try {
            this.loadRom("jace/data/DiskII.rom");
        }
        catch (IOException ex) {
            Logger.getLogger(CardDiskII.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.diskDrive1Icon = Utility.loadIcon("disk_ii.png");
        this.diskDrive2Icon = Utility.loadIcon("disk_ii.png");
        this.drive1 = new DiskIIDrive();
        this.drive2 = new DiskIIDrive();
        this.reset();
    }

    @Override
    public String getDeviceName() {
        return "Disk ][ Controller";
    }

    @Override
    public void reset() {
        this.currentDrive = this.drive1;
        this.drive1.reset();
        this.drive2.reset();
        if (Emulator.getFrame() != null) {
            Emulator.getFrame().removeIndicators(this);
        }
    }

    @Override
    protected void handleIOAccess(int register, RAMEvent.TYPE type, int value, RAMEvent e) {
        switch (register) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.currentDrive.step(register);
                break;
            }
            case 8: {
                this.currentDrive.setOn(false);
                break;
            }
            case 9: {
                this.currentDrive.setOn(true);
                Emulator.getFrame().addIndicator(this, this.currentDrive == this.drive1 ? this.diskDrive1Icon : this.diskDrive2Icon);
                break;
            }
            case 10: {
                this.currentDrive = this.drive1;
                break;
            }
            case 11: {
                this.currentDrive = this.drive2;
                break;
            }
            case 12: {
                this.currentDrive.write();
                e.setNewValue(this.currentDrive.readLatch());
                break;
            }
            case 15: {
                this.currentDrive.setWriteMode();
            }
            case 13: {
                if (e.getType() == RAMEvent.TYPE.WRITE) {
                    this.currentDrive.setLatchValue((byte)e.getNewValue());
                }
                e.setNewValue(this.currentDrive.readLatch());
                break;
            }
            case 14: {
                this.currentDrive.setReadMode();
                if (this.currentDrive.disk != null && this.currentDrive.disk.writeProtected) {
                    e.setNewValue(128);
                    break;
                }
                e.setNewValue(0);
            }
        }
        this.tweakTiming();
    }

    @Override
    protected void handleFirmwareAccess(int register, RAMEvent.TYPE type, int value, RAMEvent e) {
    }

    public void loadRom(String path) throws IOException {
        InputStream romFile = CardDiskII.class.getClassLoader().getResourceAsStream(path);
        int cxRomLength = 256;
        byte[] romData = new byte[256];
        if (romFile.read(romData) != 256) {
            throw new IOException("Bad Disk ][ ROM size");
        }
        this.getCxRom().loadData(romData);
    }

    @Override
    public void tick() {
    }

    @Override
    public void reconfigure() {
        this.diskDrive1Icon.setDescription("S" + this.getSlot() + "D1");
        this.diskDrive2Icon.setDescription("S" + this.getSlot() + "D2");
        try {
            if (this.disk1 == null) {
                this.drive1.ejectDisk();
            } else {
                this.drive1.insertDisk(this.disk1);
            }
            if (this.disk2 == null) {
                this.drive2.ejectDisk();
            } else {
                this.drive2.insertDisk(this.disk2);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(CardDiskII.class.getName()).log(Level.SEVERE, null, ex);
        }
        super.reconfigure();
    }

    private void tweakTiming() {
        if (this.drive1.isOn() || this.drive2.isOn()) {
            if (USE_MAX_SPEED) {
                Motherboard.requestSpeed(this);
            }
        } else {
            Motherboard.cancelSpeedRequest(this);
        }
    }

    @Override
    protected void handleC8FirmwareAccess(int register, RAMEvent.TYPE type, int value, RAMEvent e) {
    }
}

